%This function is to run the survival analysis and find prognostic values
%using Significance analysis of microarrays(SAM) method in R

% 1st open and load library(rscproxy) in R!!!!
wdR = regexprep(current_dir, '\\', '\\\');
openR;
evalR(['setwd("' wdR '")']);
evalR('library(survival)');
evalR('library(samr)');

evalR('joindata <- read.table("jdata_filterACCENSE_means.txt",sep="\t", header=TRUE)')
evalR('msdata <- joindata[,1:82]')
% evalR('msdata <- joindata[,40:121]')

% Get Clinical Survivals Data
putRdata('survtime',jdata.Surv);
putRdata('status',jdata.Status);
% putRdata('msdata', Avg_Spectrum);

evalR('set.seed(3)');
evalR('d <- list(x=t(msdata),y=joindata$Surv,censoring.status=joindata$Status, geneid=as.character(1:82),genenames=names(msdata))')

evalR('samr.obj <- samr(d,  resp.type="Survival", nperms=200)')
evalR('delta.table <- samr.compute.delta.table(samr.obj)')
delta = getRdata('delta.table');
 disp(delta);

evalR('delta = 0.6586')
evalR('png("Prognostic_plot.png")'); %Saving the graph
evalR('curve <- samr.plot(samr.obj,delta)')

evalR('siggenes.table <- samr.compute.siggenes.table(samr.obj,delta, d, delta.table)')
evalR('siggenes.table')
getRdata('siggenes.table')
% Significant_Masses = getRdata('siggenes.table')
% disp(Significant_Masses);

closeR;

%% ========= Open R and write the following code there
% % library(survival)
% % library(samr)
% %     
% % set.seed(3)
% % setwd(dir="M:\\LUMC Research\\Tumor Hetrogeniety_tSNE Analysis\\Data\\Tumor_Heterogeneity\\") # where the file is
% % 
% % joindata <- read.table("jdata_filterACCENSE_means.txt",sep="\t", header=TRUE) #name of the file
% % msdata <- joindata[,40:121]
% % 
% % d=list(x=t(msdata),y=joindata$Surv,censoring.status=joindata$Status, geneid=as.character(1:82),genenames=names(msdata)) 
% % 
% % samr.obj=samr(d, resp.type="Survival", nperms=200)
% % delta.table <- samr.compute.delta.table(samr.obj)
% %  
% % delta=   0.6586                             #this is the value in delta.table, lowest FDR
% % samr.plot(samr.obj,delta)
% %  
% % siggenes.table<-samr.compute.siggenes.table(samr.obj,delta, d, delta.table)
% % siggenes.table